 ; Ŀ
 ;   Lv - replace commands so that snap can be turned off and on.          
 ;   Copyright 1997, 2004, 2005 by Rocket Software Ltd.                    
 ;   Note that a lisp takes precedence over command aliases if it is       
 ;   loaded after acad.pgp.                                                
 ;   Routines: E  - Erase                                                  
 ;             Ex - Extend                                                 
 ;             LL - List                                                   
 ;             M  - Move                                                   
 ;             Rr - Rotate                                                 
 ;             T  - Trim                                                   
 ;             X  - Explode (not currently active)                         
 ;                                                                         
 ;   There are no children's books where the hero is a slug.               
 ; 

 ; Ŀ
 ;   Subroutine Gecx - run an Extend (boundary) type command, handle snap. 
 ;   Arguments: Comda, the command to run.                                 
 ;              Comdb, the alternate function name.                        
 ; 
 (defun gecx (comda comdb / 2ss ss sss num *error* snp)
 ; Ŀ
 ;   Calling a command will kill grips, so must see if anything is         
 ;   gripped before starting Undo.                                         
 ; 
  (setq 2ss (ssgetfirst))
 ; Ŀ
 ;   Now start the undo group and make an error handler.                   
 ; 
  (command ".undo" "be")
  (setq snp (getvar "snapmode"))
  (defun *error* (shk /)
   (setvar "snapmode" snp)
   (setvar "cmdecho" 0)
  (princ))
 ; Ŀ
 ;   Find or make the cutting edge set.                                    
 ; 
  (setq ss (car 2ss))
  (setq sss (cadr 2ss))
  (cond ((and ss sss)
         (setq num 0)
         (while (setq enam (ssname ss num))
                (setq num (1+ num))
                (ssadd enam ss)))
        (sss (setq ss sss))
        ((null ss)
         (prompt "Select boundary edges: ")
         (setvar "snapmode" 0)
         (setq ss (ssget))))
 ; Ŀ
 ;   Start the command, either with a boundary edge ss or without,         
 ;   which will use everything in the drawing.                             
 ; 
  (if ss
      (command comda ss "")
      (command comda ""))
 ; Ŀ
 ;   Make sure snap is off, select objects to extend or trim, depending    
 ;   on what we are up to.                                                 
 ; 
  (prompt (strcat "Select object to "
                  (substr comda 2)
                  " or shift-select to "
                  comdb
                  " or [Project/Edge/Undo]: "))
  (setvar "snapmode" 0)
  (setvar "cmdecho" 1)
  (while (/= (getvar "cmdactive") 0)
         (command pause))
 ; Ŀ
 ;   Reset Snap, reset Cmdecho, end the Undo group.                        
 ; 
  (setvar "snapmode" snp)
  (setvar "cmdecho" 0)
  (command ".undo" "end")
 (princ))
 ; Ŀ
 ;   Subroutine Gecx end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Gecxe - run an Erase type command, handle snap.            
 ;   Arguments: Comda, the command to run.                                 
 ; 
 (defun gexce (comda / 2ss snapp *error* ss sss)
  (setq 2ss (ssgetfirst))  ; a command cancels grips so this must come first
  (command ".undo" "be")
  (setq snapp (getvar "snapmode"))
  (defun *error* (shk /)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
  (princ))
  (setvar "snapmode" 0)
  (if (setq ss (car 2ss))
      (command comda ss ""))
  (if (setq sss (cadr 2ss))
      (command comda sss ""))
  (if (and (null ss) (null sss))
      (if (setq ss (ssget))
          (command comda ss "")
          (prompt "\nNothing selected.")))
  (setvar "snapmode" snapp)
  (command ".undo" "end")
 (princ))
 ; Ŀ
 ;   Subroutine Gecxe end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Genc - run a Move type command, control snap.              
 ;   Arguments: Comda, the command to run.                                 
 ; 
 (defun genc (comda / 2ss snp *error* ss)
  (setq 2ss (ssgetfirst))
  (command ".undo" "be")
  (setq snp (getvar "snapmode"))
  (defun *error* (shk /)
   (setvar "snapmode" snp)
   (setvar "cmdecho" 0)
   (command ".undo" "end")
  (princ))
  (setvar "snapmode" 0)
  (if (not (or (setq ss (car 2ss))
               (setq ss (cadr 2ss))))
      (setq ss (ssget)))
  (if (null ss)
      (prompt "\nNothing selected.")
      (progn
           (command comda ss)
           (setvar "cmdecho" 1)
           (command "")
           (setvar "snapmode" snp)
           (while (/= (getvar "cmdactive") 0)
                  (command pause))))
  (setvar "cmdecho" 0)
  (command ".undo" "end")
 (princ))
 ; Ŀ
 ;   Subroutine Genc end.                                                  
 ; 

 ; Ŀ
 ;   Erase.                                                                
 ; 
 (defun c:e () (gexce ".erase") (princ))

 ; Ŀ
 ;   Extend.                                                               
 ; 
 (defun c:ex () (gecx ".extend" "trim") (princ))

 ; Ŀ
 ;   Explode: this isn't currently enabled because explode isn't like      
 ;   other commands - it fails oddly if it encounters something it can't   
 ;   explode or an empty selection set.  A much more elaborate routine     
 ;   could probably be written, but it would have to know all explodeable  
 ;   entity types and have much better error handling.                     
 ;   It isn't in any case really clear that exploding is particularly      
 ;   hindered by snap being active.                                        
 ; 
; (defun c:x () (gexce ".explode") (princ))

 ; Ŀ
 ;   List.                                                                 
 ; 
 (defun c:ll () (gexce ".list") (princ))

 ; Ŀ
 ;   Move.                                                                 
 ; 
 (defun c:m () (genc ".move") (princ))

 ; Ŀ
 ;   Rotate.                                                               
 ; 
 (defun c:rr () (genc ".rotate") (princ))

 ; Ŀ
 ;   Trim.                                                                 
 ; 
 (defun c:t () (gecx ".trim" "extend") (princ))

 (princ)